require "fiddle/import"
module Libc
  extend Fiddle::Importer
  dlload "libc.so.6"
  extern "int alarm(int)"
end

module Seccomp
  extend Fiddle::Importer
  dlload "libseccomp.so.2"
  extern "void* seccomp_init(int)"
  extern "int seccomp_rule_add(void*, int, int, int)"
  extern "int seccomp_load(void*)"

  SCMP_ACT_KILL     = 0x00000000
  SCMP_ACT_TRAP     = 0x00030000
  SCMP_ACT_ERRNO_0  = 0x00050000 # ignore syscall
  SCMP_ACT_ALLOW    = 0x7fff0000
end

class Restrict
  def self.set_timeout
    Libc.alarm(10)
  end

  def self.seccomp
    ctx = Seccomp.seccomp_init(Seccomp::SCMP_ACT_ERRNO_0)
    ret = 0
    ret |= Seccomp::seccomp_rule_add(ctx, Seccomp::SCMP_ACT_ALLOW, 1, 0) # allow write
    ret |= Seccomp::seccomp_rule_add(ctx, Seccomp::SCMP_ACT_ALLOW, 60, 0) # allow exit
    ret |= Seccomp::seccomp_rule_add(ctx, Seccomp::SCMP_ACT_ALLOW, 3, 0) # allow close
    ret |= Seccomp::seccomp_rule_add(ctx, Seccomp::SCMP_ACT_ALLOW, 12, 0) # allow brk
    ret |= Seccomp::seccomp_rule_add(ctx, Seccomp::SCMP_ACT_ALLOW, 10, 0) # allow mprotect
    ret |= Seccomp::seccomp_rule_add(ctx, Seccomp::SCMP_ACT_ALLOW, 9, 0) # allow mmap
    ret |= Seccomp::seccomp_rule_add(ctx, Seccomp::SCMP_ACT_ALLOW, 11, 0) # allow munmap
    ret |= Seccomp::seccomp_load(ctx)

    fail "Failed to setup syscall." unless ret == 0
  end
end
